//								EJEMPLO 39
//						Autor: Mikel Etxebarria
//			(c) Ingeniera de Microsistemas Programados S.L.
//						www.microcontroladores.com
//								Bilbao 2006
//
//ADIVINA EL NUMERO: Ejemplo de entretenimiento consistente en adivinar un nmero
//aleatorio generado por el PIC. Se emplea la pantalla LCD y el teclado y se disponen
//una serie de intentos.
	
#include <16f876A.h>

//Ajusta los valores de la palabra de configuracin durante el ensamblaje:
//Proteccin de cdigo y datos=OFF, LVP=OFF, WDT=OFF y OSC=XT

#fuses NOPROTECT,NOCPD,NOLVP,NOWDT,XT

// Con estas directivas las funciones "input" y "output_bit" no reprograman
// el pin de la puerta cada vez que son utilizadas. Si no se indica el
// modo fast_io se asume por defecto standard_io el cual reprograma el pin
// siempre antes de ser utilizadas estas funciones.

#use fast_io (A)
#use fast_io (B)
#use delay(clock=4000000)

#include <stdlib.h>								//Incluir funciones estndar
#include <ctype.h>								//Incluir funciones manejo caracteres
#include <lcd2.c>								//Incluir funciones de manejo del LCD
#include <kbd2.c>								//Incluir funciones de manejo del teclado

char tecla;										//Variable con valor de tecla pulsada
char string[2];									//String con dgitos tecleados
int16	aleatorio;								//Variable con n aleatorio
int numero;										//Variable con n entero tecleado
int	minimo;										//Variable para almacenar valor mnimo
int maximo;										//Variable para almacenar valor mximo
int intentos;									//Variable para n de intentos	

main()
{  	
SETUP_ADC_PORTS(NO_ANALOGS);					//Puerta A Digital
set_tris_a(0x3F);								//RA0-RA5 entradas
set_tris_b(0x00);								//RB0-RB7 salidas	   
lcd_init();										//Secuencia de inicio del LCD
setup_timer_1(T1_INTERNAL | T1_DIV_BY_1); 		//TMR1 genera N aleatorio

	while(1)
	{	
	bucle:
	lcd_enviar(LCD_COMANDO,LCD_CLEAR);			//Borra pantalla
	printf(lcd_putc,"  ADIVINA EL N.");
	lcd_gotoxy(1,2);							//Posiciona el cursor
	printf(lcd_putc," (C) Continuar");
		
	minimo=0;
	maximo=99;
	intentos=5;									//Actualiza las variables del juego

	while (kbd_getc()!= 0x43);					//Espera se pulse C

	lcd_enviar(LCD_COMANDO,LCD_CLEAR);			//Borra pantalla
	aleatorio=(get_timer1()%100);				//Obtiene n aleatorio entre 0 y 99

		while (intentos!=0)	
		{
		lcd_enviar(LCD_COMANDO,LCD_CLEAR);		//Borra pantalla
		printf(lcd_putc,"Entre %02u-%02u  (%1u)",minimo,maximo,intentos);
		lcd_gotoxy(1,2);
		printf(lcd_putc,"Tecla N. ");			//Visualiza la pantalla de juego	

		//Espera que se tecleen dos dgitos vlidos comprendidos entre 0 y 9 cada uno

		do {
			tecla=kbd_getc();					//Espera se pulse una tecla
			} while (isdigit(tecla)==false);	//Coprueba sea entre 0 y 9	
		lcd_putc(tecla);						//Visualiza en LCD
		string[0]=tecla;						//Salva 1er. dgito decenas
				
		do {
			tecla=kbd_getc();					//Espera se pulse otra tecla
			} while (isdigit(tecla)==false);	//Coprueba sea entre 0 y 9
		lcd_putc(tecla);						//Visualiza en LCD
		string[1]=tecla;						//Salva 2. dgito unidades	
		numero=atoi(string);					//Convierte la string en n entero

		if (numero>aleatorio)
			{
			maximo=numero;						//Ajusta nuevo mximo
			lcd_enviar(LCD_COMANDO,LCD_CLEAR);
			printf(lcd_putc,"ERROR, es menor");	//Mensaje de error (menor que..)
			delay_ms(1000);						//Temporiza 1 segundo
			}
		else if (numero < aleatorio)
			{
			minimo=numero;						//Ajusta nuevo mnimo
			lcd_enviar(LCD_COMANDO,LCD_CLEAR);
			printf(lcd_putc,"ERROR, es mayor");	//Mensaje de error (mayor que..)
			delay_ms(1000);						//Temporiza 1 segundo
			}
		else  if (numero==aleatorio)
			{
			lcd_enviar(LCD_COMANDO,LCD_CLEAR);
			printf(lcd_putc," !! ACERTASTE !!");
			lcd_gotoxy(1,2);					//Posiciona el cursor
			printf(lcd_putc,"N. Premiado %02lu",aleatorio); //Mensaje de acierto
			delay_ms(2000);						//Temporiza 2 segundos
			goto bucle;
			} 
		intentos--;								//Ajusta n de intentos
		}
		lcd_enviar(LCD_COMANDO,LCD_CLEAR);		//Borra pantalla
		printf(lcd_putc,"!oooh GAME OVER!");	//Fin de partida
		delay_ms(1000);							//Temporiza 1 segundo
	}
}	
